/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.lookups.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.lookups.v1.PhoneNumberFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PhoneNumber
extends Resource {
    private static final long serialVersionUID = 86959676472232L;
    private final Map<String, String> callerName;
    private final String countryCode;
    private final com.twilio.type.PhoneNumber phoneNumber;
    private final String nationalFormat;
    private final Map<String, String> carrier;
    private final Map<String, Object> addOns;
    private final URI url;

    public static PhoneNumberFetcher fetcher(com.twilio.type.PhoneNumber pathPhoneNumber) {
        return new PhoneNumberFetcher(pathPhoneNumber);
    }

    public static PhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (PhoneNumber)objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (PhoneNumber)objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PhoneNumber(@JsonProperty(value="caller_name") Map<String, String> callerName, @JsonProperty(value="country_code") String countryCode, @JsonProperty(value="phone_number") com.twilio.type.PhoneNumber phoneNumber, @JsonProperty(value="national_format") String nationalFormat, @JsonProperty(value="carrier") Map<String, String> carrier, @JsonProperty(value="add_ons") Map<String, Object> addOns, @JsonProperty(value="url") URI url) {
        this.callerName = callerName;
        this.countryCode = countryCode;
        this.phoneNumber = phoneNumber;
        this.nationalFormat = nationalFormat;
        this.carrier = carrier;
        this.addOns = addOns;
        this.url = url;
    }

    public final Map<String, String> getCallerName() {
        return this.callerName;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final com.twilio.type.PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getNationalFormat() {
        return this.nationalFormat;
    }

    public final Map<String, String> getCarrier() {
        return this.carrier;
    }

    public final Map<String, Object> getAddOns() {
        return this.addOns;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)o;
        return Objects.equals(this.callerName, other.callerName) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.nationalFormat, other.nationalFormat) && Objects.equals(this.carrier, other.carrier) && Objects.equals(this.addOns, other.addOns) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.callerName, this.countryCode, this.phoneNumber, this.nationalFormat, this.carrier, this.addOns, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("callerName", this.callerName).add("countryCode", (Object)this.countryCode).add("phoneNumber", (Object)this.phoneNumber).add("nationalFormat", (Object)this.nationalFormat).add("carrier", this.carrier).add("addOns", this.addOns).add("url", (Object)this.url).toString();
    }

    public static enum Type {
        LANDLINE("landline"),
        MOBILE("mobile"),
        VOIP("voip");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }
    }
}

